<div class="site-header container-fluid">
    <?php
    	$logo = get_field('company_logo','option');
    	?>
    	
    <nav class="header-nav">
        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
            <img src="<?= $logo['url'];?>" alt="<?php bloginfo('name'); ?>" />
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
                $brandArgs = array(
                    'parent' => 0,
                    'hide_empty' => 0,
                );
                $brands = get_terms( 
                   'brand', 
                   $brandArgs
                );
                if ($brands){
                    ?>
                     <ul class="nav--departments" id="nav--departments">
                        <?php
                        $i=0;
                        foreach ($brands as $brand) {
                            $i++;                        
                            $image = get_field('brand_logo', 'brand_' .$brand->term_id);
                            $featuredBrands = get_field('featured_brands', 'brand_' .$brand->term_id);
                            $maintenance = get_field('maintenance', 'brand_' .$brand->term_id);
                            $link_overlay = get_field('link_overlay', 'brand_' .$brand->term_id);
                            if($maintenance){
                                $brandUrl='';
                                $linkClasses = 'preventDefault maintenance--on';
                            }else{
                                $brandUrl = esc_url(home_url('/brand/'.$brand->slug));
                                $linkClasses = 'preventDefault';
                            }
                        ?>
                        <li class="nav--department">
                            <a class="<?=$linkClasses;?>" href="<?=$brandUrl;?>"> 
                            <?php if($image){?>
                                <img src='<?=$image['url'];?>' alt=''/><?php }?><?=$brand->name;?><?php if ($maintenance){
                            ?>
                                <span class="cat-overlay"><?=$link_overlay;?></span>
                            <?php
                                }
                            ?>
                            </a>
                            <?php
                            // Subnavs
                            $brandsID=null;
                            $brandUL=null;
                            if(!$maintenance){
                                $subBrandArgs = array(
                                    'hierarchical' => 1,
                                    'show_option_none' => '',
                                    'hide_empty' => 0,
                                    'parent' => $brand->term_id,
                                    'taxonomy' => 'brand',
                                    'brand' 
                                );
                                $subBrands = get_categories( 
                                    $subBrandArgs
                                );
                                ?>
                                <ul class="department-wrapper">
                                    <li><a>Brands</a>
                                        <ul class="department-sub"><li><div class="top-nav--'.$i.'"><div class="container">
                                        <?php
                                        //Featured Brands
                                        if($featuredBrands){
                                            ?>
                                            <div>
                                                <strong>
                                                    <a class="sub-heading">Featured Products</a>
                                                </strong>
                                                <ul class="department-sub__featured-brands">
                                                <?php
                                                foreach ($featuredBrands as $featuredBrand){
                                                ?>
                                                    <li><a href="<?= esc_url(home_url('/brand/'.$featuredBrand->slug));?>"><?=$featuredBrand->name;?></a></li>
                                                <?php
                                                }
                                                ?>
                                                </ul>
                                            </div>
                                            <?php
                                        }
                                            // Get Brands
                                            if($subBrands){
                                           ?>
                                            <div>
                                                <strong><a class="sub-heading">A-Z Brands</a></strong>
                                                <ul class="department-sub__brands">
                                                <?php
                                                foreach ($subBrands as $subBrand) {
                                                  ?>
                                                  <li><a href="<?=esc_url(home_url('/brand/'.$subBrand->slug));?>"><?=$subBrand->name;?></a></li>
                                              <?php
                                                  }
                                                ?>
                                                </ul>
                                            </div>
                                        </ul>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                        <?php
                        }
                        //Fragrance of the month
                        $args = array(
                            'meta_key' => '_wp_page_template',
                            'meta_value' => 'template-scent-of-the-month.php',
                            'hierarchical' => 0
                        );
                        $scentPages = get_pages($args); 
                        ?>
                        <ul class="department-sub">
                            <li>
                            <div class="top-nav--'.$i.'">
                                <div class="container">
                                    <ul>
                                    <?php
                                    if($scentPages){
                                    ?>
                                        <li>
                                            <a>Scents of the Month</a>
                                            <div>
                                                <ul class="department-sub__featured-brands">
                                                    <?php
                                                    foreach ($scentPages as $scentPage){
                                                    ?>
                                                   <li><a href="<?=get_permalink($scentPage->id);?>"><?=$scentPage->post_title;?></a></li>
                                                   <?php
                                                }
                                                ?>                            
                                                </ul>
                                            </div>
                                        </li>
                                        <?php
                                        }
                                       ?>
                                    
                                    </ul>
                               </div>
                            </div>
                            </li>
                        </ul>
                    
               <li><a class="sub-heading" href="/shop/">Shop</a></li>
           </ul>
           <?php
            }
        }
        ?>                                     
    </ul>
                    <?php
                }
                ?>
            
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            ?>
    
            <ul class="contact">
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
                <?php if (get_field('contact_email_address', 'option')) { ?>
                <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?></a></li>
                <?php } ?>
            </ul>
        </div>
        <?php 
        get_search_form();
        ?>
    </nav>
</div>